/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.jobs;

import com.minecolonies.api.client.render.modeltype.ModModelTypes;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.colony.jobs.AbstractJobCrafter;
import com.minecolonies.coremod.entity.ai.citizen.enchanter.EntityAIWorkEnchanter;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class JobEnchanter
extends AbstractJobCrafter<EntityAIWorkEnchanter, JobEnchanter> {
    private static final int MAX_WAITING_TICKS = 60;
    private BlockPos posToDrainFrom = null;
    private int waitingTicks = 0;

    public JobEnchanter(ICitizenData entity) {
        super(entity);
    }

    @Override
    @NotNull
    public ResourceLocation getModel() {
        return ModModelTypes.STUDENT_ID;
    }

    @Override
    public EntityAIWorkEnchanter generateAI() {
        return new EntityAIWorkEnchanter(this);
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        if (compound.func_150296_c().contains("buildingtodrain")) {
            this.posToDrainFrom = BlockPosUtil.read(compound, "buildingtodrain");
        }
        this.waitingTicks = compound.func_74762_e("waitingticks");
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        if (this.posToDrainFrom != null) {
            BlockPosUtil.write(compound, "buildingtodrain", this.posToDrainFrom);
        }
        compound.func_74768_a("waitingticks", this.waitingTicks);
        return compound;
    }

    public void setBuildingToDrainFrom(BlockPos pos) {
        this.posToDrainFrom = pos;
    }

    public BlockPos getPosToDrainFrom() {
        return this.posToDrainFrom;
    }

    public boolean incrementWaitingTicks() {
        if (++this.waitingTicks > 60) {
            this.waitingTicks = 0;
            return false;
        }
        return true;
    }
}

